/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import ctrl.Ctrl;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.swing.SwingUtilities;

public class Ihm
implements Initializable {
    @FXML
    private Button button;
    @FXML
    private Label label;
    @FXML
    private TextField inputA;
    @FXML
    private TextField inputB;
    private Ctrl refCtrl = null;
    private final String fxml;

    public Ihm() {
        this.fxml = "/ihm/Ihm.fxml";
    }

    public void start() {
        Ihm myself = this;
        Callback controllerFactory = type -> myself;
        SwingUtilities.invokeLater(() -> {
            new JFXPanel();
            Platform.runLater(() -> {
                try {
                    Stage stage = new Stage();
                    FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource(this.fxml));
                    fxmlLoader.setControllerFactory(controllerFactory);
                    Parent root = (Parent)fxmlLoader.load();
                    Scene scene = new Scene(root);
                    stage.setScene(scene);
                    stage.setTitle("Simple MVC");
                    stage.show();
                }
                catch (IOException ex) {
                    System.out.println("Can't start the IHM because : " + ex);
                    Platform.exit();
                }
            });
        });
    }

    @FXML
    private void handleButtonAction(ActionEvent event) {
        this.refCtrl.additionne(Integer.parseInt(this.inputA.getText()), Integer.parseInt(this.inputB.getText()));
    }

    public void afficheVert(String message) {
        this.label.setStyle("-fx-text-fill: green;");
        this.label.setText(message);
    }

    public void afficheBleu(String message) {
        this.label.setStyle("-fx-text-fill: blue;");
        this.label.setText(message);
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.inputA.setText("2");
        this.inputB.setText("5");
    }

    public void setRefCtrl(Ctrl refCtrl) {
        this.refCtrl = refCtrl;
    }

    public Ctrl getRefCtrl() {
        return this.refCtrl;
    }
}

