package ctrl;

import ihm.Ihm;
import wrk.Wrk;

/**
 * Modèle d'application "MVC2" réalisé sans interfaces (qui sont vues au 226a).
 * <p>
 * Cette classe représente le contrôleur de l'application MVC2.
 *
 * @author EMF-Informatique
 */
public class Ctrl {

    /**
     * Constructeur de la classe contrôleur.
     */
    public Ctrl() {
        refWrk = null;
        refIhm = null;
    }

    /**
     * Méthode permettant de démarrer l'interface graphique.
     */
    public void startIhm() {
        refIhm.start();
    }

    /**
     * Méthode permettant de retourner l'addition entre deux nombres.
     * Si le nombre est pair demander à l'afficher en vert, sinon l'afficher en
     * bleu.
     *
     * @param a Le premier nombre.
     * @param b Le deuxième nombre.
     */
    public void additionne( int a, int b ) {
        int result = refWrk.additionne( a, b );
        if ( result % 2 == 0 ) {
            refIhm.afficheVert( a + " + " + b + " = " + result );
        } else {
            refIhm.afficheBleu( a + " + " + b + " = " + result );
        }
    }

    public void setRefWrk( Wrk refWrk ) {
        this.refWrk = refWrk;
    }

    public void setRefIhm( Ihm refIhm ) {
        this.refIhm = refIhm;
    }

    public Ihm getRefIhm() {
        return refIhm;
    }

    public Wrk getRefWrk() {
        return refWrk;
    }

    private Wrk refWrk;
    private Ihm refIhm;
}
