/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import beans.Person;
import ctrl.ICtrlIhm;
import ihm.EditIhm;
import ihm.IIhmCtrl;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.swing.SwingUtilities;

public class Ihm
implements Initializable,
IIhmCtrl {
    @FXML
    private Label lblLastname;
    @FXML
    private Label lblFirstname;
    @FXML
    private Label lblBirthDate;
    @FXML
    private Label lblAge;
    @FXML
    private Button btnLeft;
    @FXML
    private Button btnEdit;
    @FXML
    private Button btnRight;
    private ICtrlIhm refCtrl = null;
    private final String fxml;
    private int indexOfPerson;
    private Person currentPerson;

    public Ihm() {
        this.fxml = "/ihm/Ihm.fxml";
    }

    @Override
    public void start() {
        Ihm myself = this;
        Callback controllerFactory = type -> myself;
        SwingUtilities.invokeLater(() -> {
            new JFXPanel();
            Platform.runLater(() -> {
                try {
                    Stage stage = new Stage();
                    FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource(this.fxml));
                    fxmlLoader.setControllerFactory(controllerFactory);
                    Parent root = (Parent)fxmlLoader.load();
                    Scene scene = new Scene(root);
                    stage.setScene(scene);
                    stage.setTitle("Simple MVC2");
                    stage.show();
                }
                catch (IOException ex) {
                    System.out.println("Can't start the IHM because : " + ex);
                    Platform.exit();
                }
            });
        });
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.indexOfPerson = 0;
        this.currentPerson = this.refCtrl.getPerson(this.indexOfPerson);
        this.displayCurrentPerson();
        this.btnLeft.setDisable(true);
    }

    @FXML
    private void editPerson(ActionEvent event) {
        Stage childStage = this.openChildWindow();
        EditIhm editIhm = (EditIhm)childStage.getUserData();
        editIhm.setPerson(this.currentPerson);
        this.currentPerson = this.refCtrl.getPerson(this.indexOfPerson);
        this.displayCurrentPerson();
    }

    @FXML
    private void previous(ActionEvent event) {
        --this.indexOfPerson;
        this.currentPerson = this.refCtrl.getPerson(this.indexOfPerson);
        this.displayCurrentPerson();
        this.changeButtonState();
    }

    @FXML
    private void next(ActionEvent event) {
        ++this.indexOfPerson;
        this.currentPerson = this.refCtrl.getPerson(this.indexOfPerson);
        this.displayCurrentPerson();
        this.changeButtonState();
    }

    private void displayCurrentPerson() {
        this.lblLastname.textProperty().bind((ObservableValue)this.currentPerson.lastnameProperty());
        this.lblFirstname.textProperty().bind((ObservableValue)this.currentPerson.firstnameProperty());
        this.lblBirthDate.textProperty().bind((ObservableValue)this.currentPerson.birthDateProperty().asString());
        this.lblAge.textProperty().bind((ObservableValue)this.currentPerson.ageProperty().asString());
    }

    private void changeButtonState() {
        if (this.refCtrl.isNextAvailable(this.indexOfPerson)) {
            this.btnRight.setDisable(false);
        } else {
            this.btnRight.setDisable(true);
        }
        if (this.refCtrl.isPreviousAvailable(this.indexOfPerson)) {
            this.btnLeft.setDisable(false);
        } else {
            this.btnLeft.setDisable(true);
        }
    }

    private Stage openChildWindow() {
        Stage childStage = null;
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/ihm/EditIhm.fxml"));
            Parent root = (Parent)fxmlLoader.load();
            EditIhm editIhm = (EditIhm)fxmlLoader.getController();
            childStage = new Stage();
            childStage.initModality(Modality.WINDOW_MODAL);
            childStage.initOwner(this.btnEdit.getScene().getWindow());
            childStage.setTitle("Edit Value");
            childStage.setUserData((Object)editIhm);
            Scene scene = new Scene(root);
            childStage.setScene(scene);
            childStage.show();
        }
        catch (IOException ex) {
            Logger.getLogger(Ihm.class.getName()).log(Level.SEVERE, null, ex);
        }
        return childStage;
    }

    public ICtrlIhm getRefCtrl() {
        return this.refCtrl;
    }

    public void setRefCtrl(ICtrlIhm refCtrl) {
        this.refCtrl = refCtrl;
    }
}

