package beans;

import java.util.Calendar;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

/**
 *
 * @author EMF-Informatique
 */
public class Person {

    /**
     * Constructeur de la classe Personne. 
     * Elle permet de définir une personne avec un nom, un prénom, une date de naissance et un âge.
     * 
     * @param lastname Le nom de la personne
     * @param firstname Le prénom de la personne
     * @param birthDate L'année de naissance de la personne
     */
    public Person(String lastname, String firstname, int birthDate)
    {
        this.lastname = new SimpleStringProperty(this, "lastname");
        this.setLastname(lastname);
        this.firstname = new SimpleStringProperty(this, "firstname");
        this.setFirstname(firstname);
        this.age = new SimpleIntegerProperty(this, "age");
        this.birthDate = new SimpleIntegerProperty(this, "birthDate");
        //permet d'écouter les changement de la propriété anneeDeNaissance et calculer l'âge automatiquement.
        birthDateProperty().addListener((observable, oldValue, newValue) -> {
            this.setAge(Calendar.getInstance().get(Calendar.YEAR) - newValue.intValue());
        });
        this.setBirthDate(birthDate);
        
    }
    
    /**
     * Getter du nom de la personne.
     * @return Le nom de la personne.
     */
    public String getLastname() {
        return lastname.get();
    }

    /**
     * Setter du nom de la personne.
     * @param lastname Le nom de la personne.
     */
    public void setLastname(String lastname) {
        this.lastname.set(lastname);
    }

    /**
     * La propriété pour le binding de JavaFX
     * @return le nom
     */
    public StringProperty lastnameProperty(){
        return lastname;
    }
    
    /**
     * Getter du prénom de la personne.
     * @return Le prénom de la personne.
     */
    public String getFirstname() {
        return firstname.get();
    }

    /**
     * Setter du prénom de la personne.
     * @param firstname Le prénom de la personne.
     */
    public void setFirstname(String firstname) {
        this.firstname.set(firstname);
    }
    
    /**
     * La propriété pour le binding de JavaFX
     * @return le prenom
     */
    public StringProperty firstnameProperty(){
        return firstname;
    }

    /**
     * Getter de l'année de naissance de la personne.
     * @return L'année de naissance de la personne.
     */
    public int getBirthDate() {
        return birthDate.get();
    }

    /**
     * Setter de l'année de naissance de la personne.
     * @param birthDate L'année de naissance de la personne.
     */
    public void setBirthDate(int birthDate) {
        this.birthDate.set(birthDate);
    }
    
    /**
     * La propriété pour le binding de JavaFX
     * @return l'année de naissance
     */
    public IntegerProperty birthDateProperty(){
        return birthDate;
    }
    
    /**
     * Getter de l'âge de la personne.
     * @return L'âge de la personne.
     */
    public int getAge()
    {
        return age.get();
    }
    
    /**
     * Setter de l'âge de la personne
     * @param age L'âge de la personne
     */
    public void setAge(int age)
    {
        this.age.set(age);
    }
    
    /**
     * La propriété pour le binding de JavaFX
     * @return l'âge
     */
    public IntegerProperty ageProperty(){
        return age;
    }
    
    private final StringProperty lastname;
    private final StringProperty firstname;
    private final IntegerProperty birthDate;
    private final IntegerProperty age;
     
}
