package ctrl;

import beans.Person;
import ihm.IIhmCtrl;
import wrk.IWrkCtrl;

/**
 * Modèle d'application "MVC2" réalisé avec interfaces (qui sont vues au 226a).
 * <p>
 * Cette classe représente le contrôleur de l'application MVC2.
 *
 * @author EMF-Informatique
 */

public class Ctrl implements ICtrlWrk, ICtrlIhm {

    /**
     * Constructeur de la classe contrôleur.
     */
    public Ctrl() {
        refWrk = null;
        refIhm = null;
    }

    /**
     * Méthode permettant de démarrer l'interface graphique.
     */
    public void startIhm() {
        refIhm.start();
    }

    /**
     * Retourne la personne à la position demandée.
     *
     * @param index La position de la personne demandée.
     *
     * @return La personne à la position demandée ou null si pas trouvée.
     */
    public Person getPerson( int index ) {
        return refWrk.getPerson( index );
    }

    /**
     * Donne l'information s'il y a une personne suivante dans la liste.
     *
     * @param index La position qu'il faut tester.
     *
     * @return True s'il y a une personne suivante, sinon False.
     */
    @Override
    public boolean isNextAvailable( int index ) {
        return refWrk.isNextAvailable( index );
    }

    /**
     * Donne l'information s'il y a une personne précédente dans la liste.
     *
     * @param index La position qu'il faut tester.
     *
     * @return True s'il y a une personne précédente, sinon False.
     */
    @Override
    public boolean isPreviousAvailable( int index ) {
        return refWrk.isPreviousAvailable( index );
    }

    public IIhmCtrl getRefIhm() {
        return refIhm;
    }

    public void setRefIhm( IIhmCtrl refIhm ) {
        this.refIhm = refIhm;
    }

    public IWrkCtrl getRefWrk() {
        return refWrk;
    }

    public void setRefWrk( IWrkCtrl refWrk ) {
        this.refWrk = refWrk;
    }
    private IWrkCtrl refWrk;
    private IIhmCtrl refIhm;
}
