/*
 * 
 */
package ihm;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javafx.util.converter.NumberStringConverter;
import beans.Person;

/**
 * FXML Controller class
 *
 * @author EMF-Informatique
 */
public class EditIhm implements Initializable {

    /**
     * Initializes the controller class.
     */
    @Override
    public void initialize(URL url, ResourceBundle rb) {

    }    
    
    /**
     * Evenement appelé lors de la pression sur le bouton save.
     * @param event L'évènement du bouton save.
     */
    @FXML
    private void onSave(ActionEvent event) {
        Stage stage = (Stage) btnSave.getScene().getWindow();
        stage.close();
    }
    
    /**
     * Met à jour la personne courante et bind les informations de cette personne dans les différents champs.
     * @param person La personne courante.
     */
    public void setPerson(Person person)
    {
        txtLastname.textProperty().bindBidirectional(person.lastnameProperty());
        txtFirstname.textProperty().bindBidirectional(person.firstnameProperty());
        txtBirthDate.textProperty().bindBidirectional(person.birthDateProperty(), new NumberStringConverter());
    }
    
    @FXML
    private Button btnSave;
    @FXML
    private TextField txtLastname;
    @FXML
    private TextField txtFirstname;
    @FXML
    private TextField txtBirthDate;
}
