package wrk;

import java.util.ArrayList;
import beans.Person;
import ctrl.ICtrlWrk;

/**
 * Modèle d'application "MVC2" réalisé avec interfaces (vues au 226a).
 * <p>
 * Cette classe représente le worker principal de l'application MVC2.
 *
 * @author EMF-Informatique
 */
public class Wrk implements IWrkCtrl {

    /**
     * Constructeur de la classe Worker.
     */
    public Wrk() {
        refCtrl = null;
        persons = new ArrayList<Person>();
        persons.add( new Person( "Terrieur", "Alain", 2010 ) );
        persons.add( new Person( "Terrieur", "Alex", 2015 ) );
        persons.add( new Person( "Colella", "Dimitri", 1985 ) );
    }

    /**
     * Retourne la liste des personnes
     *
     * @return La liste des personnes
     */
    @Override
    public ArrayList<Person> getPersons() {
        return persons;
    }

    /**
     * Retourne la personne à l'index demandé.
     *
     * @param index L'index de la personne.
     *
     * @return La personne demandée ou null si l'index fourni est hors limites
     */
    @Override
    public Person getPerson( int index ) {
        Person p = null;
        try {
            p = persons.get( index );
        }
        catch ( IndexOutOfBoundsException ex ) {
        }
        return p;
    }

    /**
     * Ajoute une personne dans la structure de données
     *
     * @param person La personne à ajouter.
     *
     * @return True si la personne à bien été ajoutée, sinon False.
     */
    @Override
    public boolean addPerson( Person person ) {
        return persons.add( person );
    }

    /**
     * Donne l'information s'il y a une personne suivante dans la liste.
     *
     * @param index La position qu'il faut tester.
     *
     * @return True s'il y a une personne suivante, sinon False.
     */
    @Override
    public boolean isNextAvailable( int index ) {
        boolean result = true;
        if ( index >= persons.size() - 1 ) {
            result = false;
        }
        return result;
    }

    /**
     * Donne l'information s'il y a une personne précédente dans la liste.
     *
     * @param index La position qu'il faut tester.
     *
     * @return True s'il y a une personne précédente, sinon False.
     */
    @Override
    public boolean isPreviousAvailable( int index ) {
        boolean result = true;
        if ( index <= 0 ) {
            result = false;
        }
        return result;
    }

    public void setRefCtrl( ICtrlWrk refCtrl ) {
        this.refCtrl = refCtrl;
    }

    public ICtrlWrk getRefCtrl() {
        return refCtrl;
    }

    private ICtrlWrk refCtrl;
    private ArrayList<Person> persons;
}
