package ctrl;

import ihm.IIhmCtrl;
import wrk.IWrkCtrl;

/**
 * Modèle d'application "MVC2" réalisé avec interfaces (qui sont vues au 226a).
 * <p>
 * Cette classe représente le contrôleur de l'application MVC2.
 *
 * @author EMF-Informatique
 */
public class Ctrl implements ICtrlWrk, ICtrlIhm {

    /**
     * Constructeur de la classe contrôleur.
     */
    public Ctrl() {
        refWrk = null;
        refIhm = null;
    }

    /**
     * Méthode permettant de démarrer l'interface graphique.
     */
    public void startIhm() {
        refIhm.start();
    }

    @Override
    /**
     * Méthode permettant de retourner l'addition entre deux nombres.
     * Si le nombre est pair demander à l'afficher en vert, sinon l'afficher en
     * bleu.
     *
     * @param a Le premier nombre.
     * @param b Le deuxième nombre.
     */
    public void additionne( int a, int b ) {
        int result = refWrk.additionne( a, b );
        if ( result % 2 == 0 ) {
            refIhm.afficheVert( a + " + " + b + " = " + result );
        } else {
            refIhm.afficheBleu( a + " + " + b + " = " + result );
        }
    }

    public IIhmCtrl getRefIhm() {
        return refIhm;
    }

    public void setRefIhm( IIhmCtrl refIhm ) {
        this.refIhm = refIhm;
    }

    public IWrkCtrl getRefWrk() {
        return refWrk;
    }

    public void setRefWrk( IWrkCtrl refWrk ) {
        this.refWrk = refWrk;
    }

    private IWrkCtrl refWrk;
    private IIhmCtrl refIhm;
}
