package ihm;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;

import javax.swing.SwingUtilities;

import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javafx.util.Callback;
import ctrl.ICtrlIhm;

/**
 * Modèle d'application "MVC2" réalisé avec interfaces (vues au 226a).
 * <p>
 * Cette classe représente l'Ihm principale l'application MVC2.
 * <p>
 * Cette Ihm est en JavaFx. Le code qu'on trouve ci-dessous est donc celle du
 * "contrôleur de notre vue", vue dont le contenu est lui exprimé séparément en
 * FXML.
 *
 * @author EMF-Informatique
 */
public class Ihm implements Initializable, IIhmCtrl {

    /**
     * Constructeur de notre IHM ou l'on initalize le chemin vers la vue.
     */
    public Ihm() {
        // Si vous avez une erreur "Location is not set" c'est que ce chemin est faux.
        fxml = "/ihm/Ihm.fxml";
        refCtrl = null;
    }

    /**
     * Permet de démarrer la GUI JavaFX qui se trouve dans le chemin stocké dans
     * fxml Tout ceci pour atteindre le dispatcher thread qui est obligatoire
     * pour
     * JavaFX.
     */
    @Override
    @SuppressWarnings( "ResultOfObjectAllocationIgnored" )
    public void start() {
        Ihm myself = this;

        // Callback pour le ControllerFactory, quand JavaFX voudra créer le controlleur
        // de vue, viendra dans ce callback et donnera l'instance déjà créée au lieu
        // d'en faire une nouvelle.
        Callback<Class<?>, Object> controllerFactory = type -> {
            return myself;
        };

        // Commence l'initialisation dans le thread de java
        SwingUtilities.invokeLater( () -> {
            new JFXPanel(); // Permet d'initializer le toolkit et l'environment JavaFX
            // Accède au dispatcher thread tant aimé par JavaFX
            Platform.runLater( () -> {
                try {
                    Stage stage = new Stage();
                    FXMLLoader fxmlLoader = new FXMLLoader( getClass().getResource( fxml ) );

                    fxmlLoader.setControllerFactory( controllerFactory );

                    Parent root = ( Parent ) fxmlLoader.load();

                    Scene scene = new Scene( root );

                    stage.setScene( scene );
                    stage.setTitle( "Simple MVC2" );
                    stage.show();
                }
                catch ( IOException ex ) {
                    System.out.println( "Can't start the IHM because : " + ex );
                    Platform.exit();
                }
            } );
        } );
    }

    /**
     * L'évènement JavaFX du bouton "Add Me!"
     */
    @FXML
    private void addMe( ActionEvent event ) {
        refCtrl.additionne( Integer.parseInt( inputA.getText() ), Integer.parseInt( inputB.getText() ) );
    }

    /**
     * Méthode permettant d'afficher un message en vert.
     *
     * @param message Le message à afficher.
     */
    @Override
    public void afficheVert( String message ) {
        label.setStyle( "-fx-text-fill: green;" );
        label.setText( message );
    }

    /**
     * Méthode permettant d'afficher un message en bleu.
     *
     * @param message Le message à afficher.
     */
    @Override
    public void afficheBleu( String message ) {
        label.setStyle( "-fx-text-fill: blue;" );
        label.setText( message );
    }

    /**
     * La méthode appellée quand la vue est initializée
     */
    @Override
    public void initialize( URL url, ResourceBundle rb ) {
        inputA.setText( "2" );
        inputB.setText( "5" );
    }

    public ICtrlIhm getRefCtrl() {
        return refCtrl;
    }

    public void setRefCtrl( ICtrlIhm refCtrl ) {
        this.refCtrl = refCtrl;
    }

    @FXML
    private Label label;
    @FXML
    private TextField inputA;
    @FXML
    private TextField inputB;

    private ICtrlIhm refCtrl;
    private final String fxml;

}
