package ctrl;

import ihm.IIhmCtrl;
import wrk.IWrkCtrl;

/**
 * Modèle d'application "MVC2" réalisé avec interfaces (qui sont vues au 226a).
 * <p>
 * Cette classe représente le contrôleur de l'application MVC2.
 *
 * @author EMF-Informatique
 */
public class Ctrl implements ICtrlIhm, ICtrlWrk {

    public Ctrl() {
        refWrk = null;
        refIhm = null;
    }

    /**
     * Méthode de démarrage de l'application MVC2.
     */
    public void start() {
        refIhm.ihmStart();
        int resultat = refWrk.calcule( 10, 20 );
        refIhm.affiche( "10 + 20 = " + resultat );
    }

    /**
     * Appelée par l'ihm pour indiquer que l'application est en train de se
     * fermer. Cela permet de sauvegarder l'état de l'application.
     */
    @Override
    public void ihmExiting() {
    }
    
    public IIhmCtrl getRefIhm() {
        return refIhm;
    }

    public void setRefIhm( IIhmCtrl refIhm ) {
        this.refIhm = refIhm;
    }

    public IWrkCtrl getRefWrk() {
        return refWrk;
    }

    public void setRefWrk( IWrkCtrl refWrk ) {
        this.refWrk = refWrk;
    }

    private IIhmCtrl refIhm;
    private IWrkCtrl refWrk;

}
