package ihm;

/**
 * Modèle d'application "MVC2" réalisé avec interfaces (vues au 226a).
 * <p>
 * Cette interface représente les fonctionnalités fournies par l'ihm principale
 * au contrôleur de l'application.
 *
 * @author EMF-Informatique
 */
public interface IIhmCtrl {

    /**
     * Appelée par le contrôleur de l'application pour démarrer l'ihm.
     */
    void ihmStart();

    /**
     * Appelée par le contrôleur pour afficher le résultat.
     */
    void affiche( String message );

    /**
     * Affiche un message d'information à l'utilisateur.
     *
     * @param message le message d'information à afficher
     */
    void messageInformation( String message );

    /**
     * Affiche un message d'erreur à l'utilisateur.
     *
     * @param message le message d'erreur à afficher
     */
    void messageErreur( String message );

    /**
     * CAffiche une question de type oui/non à l'utilisateur.
     *
     * @param question la question à afficher dont la réponse doit être de type
     *                 oui/non
     *
     * @return vrai pour oui
     */
    boolean messageQuestion( String question );
}
