package ihm;

import ctrl.ICtrlIhm;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

/**
 * Modèle d'application "MVC2" réalisé avec interfaces (vues au 226a).
 * <p>
 * Cette classe représente l'Ihm principale l'application MVC2.
 * <p>
 * Cette Ihm utilise Swing pour son contenu.
 *
 * @author EMF-Informatique
 */
public class Ihm extends javax.swing.JFrame implements IIhmCtrl {

    public Ihm() {
        refCtrl = null;

        // Dire à Java de faire ressembler cette application à celles de 
        // la plateforme sur laquelle il tourne.
        try {
            UIManager.setLookAndFeel( UIManager.getSystemLookAndFeelClassName() );
        }
        catch ( Exception e ) {
        }

        // Initialiser les composants de notre ihm.
        initComponents();

        // Taille figée
        setResizable( false );

        // Centrer la fenêtre à l'écran
        setLocationRelativeTo( null );

        // Définir le titre de l'application.
        setTitle( "Demo MVC2 en Swing" );

        // Ne pas fermer la fenêtre automatiquement, nous appellerons dispose() nous-même.
        setDefaultCloseOperation( javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE );

        // Laisser la plateforme sur laquelle Java tourne placer nativement 
        // la fenêtre.
        setLocationByPlatform( true );

        // S'assurer qu'on soit informé lorsque l'utilisateur voudra quitter 
        // cette fenêtre.
        addWindowListener( new WindowAdapter() {
            @Override
            public void windowClosing( WindowEvent we ) {
                // Signalons au contrôleur que l'utilisateur veut quitter.
                ihmExiting();
            }
        } );
    }

    /**
     * Appelée par le contrôleur de l'application pour démarrer l'ihm. En
     * l'occurrence ici on ne fait que de rendre visible notre fenêtre.
     */
    @Override
    public void ihmStart() {
        // Afficher l'ihm
        setVisible( true );
    }

    /**
     * Cette méthode est appelée pour indiquer que l'application est en train de
     * se fermer. Cela permet d'informer le contrôleur de cet état de fait.
     */
    private void ihmExiting() {
        if ( messageQuestion( "Voulez-vous vraiment quitter ?" ) ) {

            // Informer le contrôleur qu'on veut quitter
            getRefCtrl().ihmExiting();

            // Arrêter ce qui doit être arrêté côté Ihm (timer, threads, ..)
            // rien à faire...
            // Fermer l'Ihm
            dispose();
        }
    }

    /**
     * Appelée par le contrôleur pour afficher le résultat.
     */
    @Override
    public void affiche( String message ) {
        jLabelMessage.setText( message );
    }

    /**
     * Affiche un message d'information à l'utilisateur.
     *
     * @param message le message d'information à afficher
     */
    @Override
    public void messageInformation( String message ) {
        ImageIcon informationIcon = new ImageIcon( getClass().getResource( "resources/icon-fine-64.png" ) );
        JOptionPane.showMessageDialog( this, message, "Information", JOptionPane.INFORMATION_MESSAGE, informationIcon );
    }

    /**
     * Affiche un message d'erreur à l'utilisateur.
     *
     * @param message le message d'erreur à afficher
     */
    @Override
    public void messageErreur( String message ) {
        ImageIcon warningIcon = new ImageIcon( getClass().getResource( "resources/icon-error-64.png" ) );
        JOptionPane.showMessageDialog( this, message, "Information", JOptionPane.INFORMATION_MESSAGE, warningIcon );
    }

    /**
     * Affiche une question de type oui/non à l'utilisateur.
     *
     * @param question la question à afficher dont la réponse doit être de type
     *                 oui/non
     *
     * @return vrai pour oui
     */
    @Override
    public boolean messageQuestion( String question ) {
        ImageIcon questionIcon = new ImageIcon( getClass().getResource( "resources/icon-question-64.png" ) );
        return ( JOptionPane.showConfirmDialog( getRootPane(), question, "Question", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, questionIcon ) == JOptionPane.YES_OPTION );
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings( "unchecked" )
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jButtonFermer = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabelMessage = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jButtonFermer.setFont(new java.awt.Font("Arial", 0, 13)); // NOI18N
        jButtonFermer.setText("Fermer");
        jButtonFermer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFermerActionPerformed(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Arial", 1, 13)); // NOI18N
        jLabel1.setText("Message");

        jLabelMessage.setBackground(new java.awt.Color(255, 255, 255));
        jLabelMessage.setFont(new java.awt.Font("Arial", 0, 13)); // NOI18N
        jLabelMessage.setText("Bonjour comment ça va ?");
        jLabelMessage.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jLabelMessage.setOpaque(true);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabelMessage, javax.swing.GroupLayout.DEFAULT_SIZE, 342, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addComponent(jButtonFermer))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabelMessage, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jButtonFermer)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonFermerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFermerActionPerformed
        ihmExiting();
    }//GEN-LAST:event_jButtonFermerActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonFermer;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabelMessage;
    // End of variables declaration//GEN-END:variables

    public ICtrlIhm getRefCtrl() {
        return refCtrl;
    }

    public void setRefCtrl( ICtrlIhm refCtrl ) {
        this.refCtrl = refCtrl;
    }

    private ICtrlIhm refCtrl;
}
